-- Fichero FDBdes.sql
-------------------------------------------------------------------
-- Borrar TABLAS de la Base de Datos DIFUSA de prueba, as como  --
-- borrar los elementos en la FMB de esta Bd (etiquetas...)      --
-------------------------------------------------------------------
-- Para que salgan los mensajes (de put_line) al instalar desde FSQL*Plus:
set serveroutput on
-- Para que salgan (o no) las ordenes a ejecutar: set echo on
set echo off
-- Para que no salgan los mensajes cuando todo va bien (los errores si salen):
set feedback off

exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> **************************************** <<<<');
exec dbms_output.put_line('>>>> **** DESINSTALACIN de una Base de  **** <<<<');
exec dbms_output.put_line('>>>> **** Datos Difusa de ejemplo.       **** <<<<');
exec dbms_output.put_line('>>>> **************************************** <<<<');
exec dbms_output.put_line('>>>>');

DECLARE
  t_APTITUD    NUMBER;
  t_EMPLEOS    NUMBER;
  t_PUESTOS    NUMBER;
  t_CIUDADES   NUMBER;
  t_DPTO       NUMBER;
  t_PERSONAL   NUMBER;
  t_REQUISITOS NUMBER;
BEGIN
  -- Calcular OBJ# para las tablas con columnas difusas:
  SELECT object_id into t_APTITUD FROM user_objects WHERE object_name='APTITUD';
  SELECT object_id into t_EMPLEOS FROM user_objects WHERE object_name='EMPLEOS';
  SELECT object_id into t_PUESTOS FROM user_objects WHERE object_name='PUESTOS';
  SELECT object_id into t_CIUDADES   FROM user_objects WHERE object_name='CIUDADES';
  SELECT object_id into t_DPTO       FROM user_objects WHERE object_name='DPTO';
  SELECT object_id into t_PERSONAL   FROM user_objects WHERE object_name='PERSONAL';
  SELECT object_id into t_REQUISITOS FROM user_objects WHERE object_name='REQUISITOS';

  -- Atributos con tratamiento difuso: Tipos 1, 2  3.
  DELETE FROM FCL WHERE OBJ#=t_APTITUD;
  DELETE FROM FCL WHERE OBJ#=t_EMPLEOS;
  DELETE FROM FCL WHERE OBJ#=t_PUESTOS;
  DELETE FROM FCL WHERE OBJ#=t_CIUDADES;
  DELETE FROM FCL WHERE OBJ#=t_DPTO;
  DELETE FROM FCL WHERE OBJ#=t_PERSONAL;
  DELETE FROM FCL WHERE OBJ#=t_REQUISITOS;

  DELETE FROM FCC WHERE OBJ#1=t_REQUISITOS;

  DELETE FROM FOL WHERE OBJ#=t_EMPLEOS;
  DELETE FROM FOL WHERE OBJ#=t_APTITUD;
  DELETE FROM FOL WHERE OBJ#=t_PUESTOS;
  DELETE FROM FOL WHERE OBJ#=t_DPTO;
  DELETE FROM FOL WHERE OBJ#=t_PERSONAL;
  DELETE FROM FOL WHERE OBJ#=t_CIUDADES;

  DELETE FROM FLD WHERE OBJ#=t_PERSONAL;
  DELETE FROM FLD WHERE OBJ#=t_PUESTOS;
  DELETE FROM FLD WHERE OBJ#=t_APTITUD;
  DELETE FROM FLD WHERE OBJ#=t_DPTO;
  DELETE FROM FLD WHERE OBJ#=t_EMPLEOS;
  DELETE FROM FLD WHERE OBJ#=t_CIUDADES;

  DELETE FROM FND WHERE OBJ#=t_APTITUD;
  DELETE FROM FND WHERE OBJ#=t_PUESTOS;
  DELETE FROM FND WHERE OBJ#=t_EMPLEOS;

  DELETE FROM FAM WHERE OBJ#=t_PERSONAL;
  DELETE FROM FAM WHERE OBJ#=t_APTITUD;
  DELETE FROM FAM WHERE OBJ#=t_DPTO;
  DELETE FROM FAM WHERE OBJ#=t_PUESTOS;
  DELETE FROM FAM WHERE OBJ#=t_EMPLEOS;
  DELETE FROM FAM WHERE OBJ#=t_CIUDADES;
  COMMIT;
END;
/

-- Borrar tablas
DROP TABLE PERSONAL CASCADE CONSTRAINTS;
DROP TABLE APTITUD CASCADE CONSTRAINTS;
DROP TABLE DPTO CASCADE CONSTRAINTS;
DROP TABLE PUESTOS CASCADE CONSTRAINTS;
DROP TABLE EMPLEOS;
DROP TABLE CIUDADES;
DROP TABLE REQUISITOS;
COMMIT;

-- Mensaje de FIN:
exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> FIN de la DESINSTALACIN: Si existieron errores, revise su texto.');
exec dbms_output.put_line('>>>>');

-- Reestablecer los valores por defecto:
set serveroutput off
set feedback on
